/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries.holdersets;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.registries.holdersets.HolderSetType;
import net.minecraftforge.registries.holdersets.ICustomHolderSet;

public record AnyHolderSet<T>(Registry<T> registry) implements ICustomHolderSet<T>
{
    public static <T> Codec<? extends ICustomHolderSet<T>> codec(ResourceKey<? extends Registry<T>> registryKey, Codec<Holder<T>> holderCodec, boolean forceList) {
        return RegistryOps.m_206832_(registryKey).xmap(AnyHolderSet::new, AnyHolderSet::registry).codec();
    }

    @Override
    public HolderSetType type() {
        return ForgeMod.ANY_HOLDER_SET.get();
    }

    public Iterator<Holder<T>> iterator() {
        return this.m_203614_().iterator();
    }

    public Stream<Holder<T>> m_203614_() {
        return this.registry.m_203611_().map(Function.identity());
    }

    public int m_203632_() {
        return this.registry.m_13562_();
    }

    public Either<TagKey<T>, List<Holder<T>>> m_203440_() {
        return Either.right(this.m_203614_().toList());
    }

    public Optional<Holder<T>> m_213653_(RandomSource random) {
        return this.registry.m_213642_(random);
    }

    public Holder<T> m_203662_(int i) {
        return (Holder)this.registry.m_203300_(i).orElseThrow(() -> new NoSuchElementException("No element " + i + " in registry " + this.registry.m_123023_()));
    }

    public boolean m_203333_(Holder<T> holder) {
        return holder.m_203543_().map(arg_0 -> this.registry.m_142003_(arg_0)).orElse(false);
    }

    public boolean m_207277_(Registry<T> registry) {
        return this.registry == registry;
    }

    @Override
    public String toString() {
        return "AnySet(" + this.registry.m_123023_() + ")";
    }
}

